(() => {
    const daySwitches = [23, 24, 25, 26, 27, 28, 29]; // Day of the week switches
    const seasonSwitches = [13, 14, 15, 16]; // Season switches
    const actorDaySystemId = 4; // Actor ID for day system
    const actorYearSystemId = 6; // Actor ID for year system
    const actor1Id = 1; // Actor ID for the player's main character

    // Function to determine the current day of the season
    function getCurrentDayOfSeason() {
        const actorDaySystem = $gameActors.actor(actorDaySystemId);
        return actorDaySystem ? actorDaySystem.mp : 0;
    }

    // Function to get the current season
    function getCurrentSeason() {
        for (let i = 0; i < seasonSwitches.length; i++) {
            if ($gameSwitches.value(seasonSwitches[i])) {
                return ['Spring', 'Summer', 'Fall', 'Winter'][i];
            }
        }
        return 'Unknown Season';
    }

    // Function to get the current year
    function getCurrentYear() {
        const actorYearSystem = $gameActors.actor(actorYearSystemId);
        return actorYearSystem ? actorYearSystem.mp + 1 : 1;
    }

    // Function to get Actor 1's name
    function getActor1Name() {
        const actor = $gameActors.actor(actor1Id);
        return actor ? actor.name() : "Unknown Hero";
    }

    // Function to calculate hearts based on Actor 1's level
    function getHeartsFromLevel() {
        const actor = $gameActors.actor(actor1Id);
        if (!actor) return "??? Hearts";
        const level = actor.level;
        const hearts = level + 2; // 3 hearts at level 1, +1 heart per level
        return `${hearts} Hearts`;
    }

    // Store the save metadata
    const _DataManager_makeSavefileInfo = DataManager.makeSavefileInfo;
    DataManager.makeSavefileInfo = function () {
        const info = _DataManager_makeSavefileInfo.call(this);
        info.actorName = getActor1Name();
        info.dayOfSeason = getCurrentDayOfSeason();
        info.season = getCurrentSeason();
        info.year = getCurrentYear();
        info.gold = $gameParty.gold(); // Add Gold amount to save info
        info.hearts = getHeartsFromLevel(); // Add hearts information to save info
        return info;
    };

    // Overriding the savefile display
    const _Window_SavefileList_drawItem = Window_SavefileList.prototype.drawItem;
    Window_SavefileList.prototype.drawItem = function (index) {
        const rect = this.itemRectWithPadding(index);
        const savefileId = index + 1;
        const info = DataManager.savefileInfo(savefileId);

        if (info) {
            const actorName = info.actorName || "Unknown Hero";
            const dayOfSeason = info.dayOfSeason || 0;
            const season = info.season || 'Unknown Season';
            const year = info.year || 1;
            const gold = info.gold || 0; // Default Gold to 0 if undefined
            const hearts = info.hearts || "??? Hearts";
            const ordinalSuffix = (num) => {
                if (num % 10 === 1 && num !== 11) return `${num}st`;
                if (num % 10 === 2 && num !== 12) return `${num}nd`;
                if (num % 10 === 3 && num !== 13) return `${num}rd`;
                return `${num}th`;
            };
            const formattedDate = `${ordinalSuffix(dayOfSeason + 1)} of ${season}, Year ${year}`;

            this.resetTextColor();
            this.drawText(
                `${actorName}, ${gold} Gold, ${hearts}`,
                rect.x,
                rect.y,
                rect.width,
                "left"
            );
            this.drawText(
                `${formattedDate}, ${info.playtime}`,
                rect.x,
                rect.y + this.lineHeight(),
                rect.width,
                "left"
            );

            // Draw the character sprite (second frame)
            if ($gameParty.leader()) {
                const character = $gameParty.leader().characterName();
                const index = $gameParty.leader().characterIndex();
                const bitmap = ImageManager.loadCharacter(character);
                const big = ImageManager.isBigCharacter(character);
                const pw = bitmap.width / (big ? 3 : 12); // Character width
                const ph = bitmap.height / (big ? 4 : 8); // Character height
                const sx = pw; // Second frame in the row
                const sy = Math.floor(index / (big ? 1 : 4)) * ph; // Same row as the character index
                const spriteX = rect.x + rect.width - pw - 10; // Right-aligned
                const spriteY = rect.y - 10; // Adjusted upward for proper alignment

                this.contents.blt(bitmap, sx, sy, pw, ph, spriteX, spriteY, pw, ph);
            }
        } else {
            this.changePaintOpacity(false);
            this.drawText("Empty", rect.x, rect.y, rect.width, "center");
            this.changePaintOpacity(true);
        }
    };
})();